import React from 'react';


export interface Service {
  id: string;
  title: string;
  description: string;
  icon: React.ElementType;
  image?: string;
  details: string[];
}

export interface TeamMember {
  id: string;
  name: string;
  designation: string;
  qualification: string;
  necReg: string;
  image: string;
}

export interface Publication {
  id: string;
  title: string;
  journal: string;
  year: string;
  link?: string;
}

export interface BuildingDesign {
  id: string;
  title: string;
  image: string;
  description: string;
  category?: string;
  // Detailed specifications
  area?: string; // e.g., "1878.00 (0-5-1-4)"
  plinthArea?: string; // e.g., "901.00 sq. ft."
  constructionTime?: string; // e.g., "8 to 12 months"
  stories?: string; // e.g., "2.5 stories"
  facingDirection?: string; // e.g., "North"
  houseStyle?: string; // e.g., "Modern Design"
  fullDescription?: string; // Detailed description
  roomSpecifications?: string[]; // List of rooms/features
}

export interface ChatMessage {
  role: 'user' | 'model';
  text: string;
  timestamp: number;
}