import { Building2, Ruler, HardHat, FileText, Activity, Layers, Palette, Calculator, Leaf } from 'lucide-react';
import { Service, TeamMember, Publication, BuildingDesign } from './types';

export const CONTACT_INFO = {
  whatsapp: "9779741836130",
  email: "visioncraftcivilsolutions@gmail.com",
  address: "Old Baneshwor-31, Kathmandu, Nepal",
  facebook: "https://www.facebook.com/share/1FKzpqemTw/?mibextid=wwXIfr"
};

export const BUILDING_DESIGNS: BuildingDesign[] = [
  {
    id: 'bd1',
    title: 'Glass Haven',
    image: '/assets/ourdesigns/1.webp',
    description: 'A modern 2.5-storey home combining contemporary style with functional living spaces.',
    category: 'Luxury, Apartment',
    area: '1878.00 (0-5-1-4)',
    plinthArea: '901.00 sq. ft.',
    constructionTime: '8 to 12 months',
    stories: '2.5 stories',
    facingDirection: 'North',
    houseStyle: 'Modern Design',
    fullDescription: `Glass Haven Residence is a modern 2.5-storey home built on 1878.00 sq. ft. of land with a plinth area of 901.00 sq. ft. Designed exclusively for personal residential use, this elegant home combines contemporary style with functional living spaces. The estimated construction period is 8 to 12 months.

The residence features multiple well-designed bedrooms, including a spacious master bedroom with an attached bathroom for added comfort and privacy. The house also includes a welcoming living room, a well-planned dining hall, a modern kitchen area, and essential utility spaces.

Additional highlights include a dedicated Puja room, a convenient parking area, and a beautiful terrace space, perfect for relaxation and family gatherings.

• Type: 3d design
• Construction: 8 to 12 months
• Land Area: 1878.00 sq.ft. ( 5 aana, 1 paisa, 3.8 daam)
• Plinth area: 901.00 sq. ft.
• Total floor: 2.5 floors
• House style: Glass Haven Residence`,
    roomSpecifications: [
      'Ground Floor: Parking Area, Pujaroom, Living Room, Dinning Hall, 1 bedroom with 1 common bathroom',
      'First Floor: 1 bedroom with 1 common bathroom, 1 master bedroom with an attached bathroom',
      'Second Floor: Terrace'
    ]
  },
  {
    id: 'bd2',
    title: 'Monarch Brick',
    image: '/assets/ourdesigns/2.webp',
    description: 'Elegant 3.5-storey residence designed for both rental and personal use.',
    category: 'Elegant, Apartment',
    area: '937.67 (0-2-2-4)',
    plinthArea: '651.22 sq. ft.',
    constructionTime: '12 to 15 months',
    stories: '3.5 stories',
    facingDirection: 'East South',
    houseStyle: 'Modern Design',
    fullDescription: `This 3.5-storey Monarch Brick Residence is built on 937.67 sq. ft. (2 Aana, 2 Paisa, 3.84 Daam) of land with a plinth area of 651.22 sq. ft., designed for both rental and personal use, with an estimated construction period of 12 to 15 months.

The ground and first floors are dedicated to rental purposes, where the ground floor includes two shutter rooms, a storeroom, and one common bathroom, while the first floor consists of two bedrooms with one common bathroom, a kitchen, and a dining hall. The remaining upper floors are designed for personal living, with the second floor featuring one bedroom with a common bathroom, a kitchen, a living room, and a dining room, and the third floor comprising two bedrooms with a common bathroom, a puja room, and an open terrace, offering a practical blend of rental income and comfortable family residence.

• Type: 3d design
• Construction: 12 to 15 months
• Land Area: 937.67 sq.ft. ( 2 aana, 2 paisa, 3.84 daam)
• Plinth area: 651.22 sq. ft.
• Total floor: 3.5 floors
• House style: Monarch Brick Residence`,
    roomSpecifications: [
      'Ground Floor: 2 Shutter Room, Storeroom, 1 Common Bathroom',
      'First Floor: 2 bedrooms with 1 common bathroom, 1 Kitchen, 1 Dinning Hall',
      'Second Floor: 1 bedroom with 1 common bathroom, 1 Kitchen, 1 Living Room, 1 Dinning Room',
      'Third Floor: 2 bedrooms with 1 common bathroom, Puja room, Open Terrace'
    ]
  },
  {
    id: 'bd3',
    title: 'Urban Pulse',
    image: '/assets/ourdesigns/3.webp',
    description: 'A 2.5-storey residence in Sanagaun, Lalitpur, designed for modern urban living.',
    category: 'Luxury, Apartment',
    area: '2106.04 (0-6-0-2)',
    plinthArea: '1213.30 sq. ft.',
    constructionTime: '8 to 12 months',
    stories: '2.5 floors',
    facingDirection: 'North',
    houseStyle: 'Modern Design',
    fullDescription: `This is a 2.5-storey Urban Pulse Residence built on a land area of 2106.04 sq.ft, with a plinth area of 1213.30 sq. ft, located in Sanagaun, Lalitpur. The house is designed for both personal living and rental purposes, and the estimated construction timeline is 8 to 12 months.

The ground floor is dedicated to rental use, while the remaining floors are designed for personal residence. The home features spacious living rooms, dining halls, and kitchens, along with multiple bedrooms, including a master bedroom with an attached bathroom. Additional amenities include an easy parking area, family lounge, laundry area, puja room, and a storeroom, ensuring comfort and functionality for modern urban living.

• Type: 3d design
• Construction: 8 to 12 months
• Land Area: 2106.04 sq.ft. ( 6 aana, 0 paisa, 2.46 daam)
• Plinth area: 1213.30 sq. ft.
• Total floor: 2.5 floors
• House style: Urban Pulse Residence`,
    roomSpecifications: [
      'Ground Floor: Parking Area, Living Room, Kitchen, Dinning Hall, 1 bedroom with 1 common bathroom, 1 master bedroom with an attached bathroom',
      'First Floor: 1 bedroom with 1 common bathroom, 1 master bedroom with an attached bathroom, Living Room, Kitchen, Dinning Hall, Storeroom',
      'Second Floor: Family Lounge, Laundry, Pooja Room, 1 bedroom with 1 common bathroom, 1 master bedroom with an attached bathroom'
    ]
  },
  {
    id: 'bd4',
    title: 'Metro Lux',
    image: '/assets/ourdesigns/4.webp',
    description: 'A 4.5-storey residence thoughtfully designed for both personal living and rental purposes.',
    category: 'Elegant, Residence',
    area: '2089.28 (0-6-0-2)',
    plinthArea: '1285.30 sq. ft.',
    constructionTime: '15 to 18 months',
    stories: '4.5 stories',
    facingDirection: 'East',
    houseStyle: 'Modern Design',
    fullDescription: `This is a 4.5-storey Metro Lux Residence built on a 2089.28 sq.ft land area with a plinth area of 1285.30 sq.ft, thoughtfully designed for both personal living and rental purposes. The construction timeline is estimated at 15 to 18 months.

The ground floor is dedicated to rental use, featuring two shutter rooms, while the upper floors are reserved for private residential use. The residence includes multiple living rooms, dining areas, and kitchens, along with multiple bedrooms, including a master bedroom with an attached bathroom. Additional spaces such as a storeroom, puja room, music room, laundry area, family gathering room, and an open terrace enhance comfort, functionality, and luxury living.

• Type: 3d design
• Construction: 15 to 18 months
• Land Area: 2089.28 sq.ft. ( 6 aana, 0 paisa, 1.67 daam)
• Plinth area: 1285.30 sq. ft.
• Total floor: 4.5 floors
• House style: Metro Lux Residence`,
    roomSpecifications: [
      'Ground Floor: 2 shutter room, 2 bedroms with 1 common bathroom, Kitchen, Dinning Hall, Living Room',
      'First Floor: 1 master bedroom with an attached bathroom, 1 bedroom with attached bathroom, 1 bedroom with 1 common bathroom, Living Room',
      'Second Floor: 1 bedroom with 1 common bathroom, 1 bedroom with an attached bathroom, Storeroom, Kitchen, Dinning Hall',
      'Third Floor: Music Gathering Room, Laundry, Puja Room, 1 common bathroom'
    ]
  },
  {
    id: 'bd5',
    title: 'Stock Form',
    image: '/assets/ourdesigns/5.webp',
    description: 'A modern stack-form elevation with clean geometric lines, located in Jhapa.',
    category: 'Luxury, Elegant',
    area: '1790 (0-5-0-4)',
    plinthArea: '1536.00 sq. ft.',
    constructionTime: '8 to 10 months',
    stories: '2.5 stories',
    facingDirection: 'South',
    houseStyle: 'Modern Design',
    fullDescription: `This is a 2.5 storey Stack Form Residential Block built on 1790.00 sq.ft of land with a plinth area of 1536.00 sq.ft, located in Jhapa. Designed exclusively for personal use, the project is estimated to be completed within 8 to 10 months.

Architecturally, the residence features a modern stack-form elevation characterized by clean geometric lines, layered massing, and flat roof detailing. Recessed balconies and well-proportioned openings enhance natural light and ventilation, while the minimal contemporary façade gives the house a refined urban character.

The residence includes multiple bedrooms, with a master bedroom featuring an attached bathroom and walk-in closet. It also offers a kitchen with a walk-in pantry, dining area,living room, multiple essential bathrooms, puja room, parking area, storeroom, and an open terrace, creating a well-planned and comfortable modern living environment.

• Type: 3d design
• Construction: 10 to 12 months
• Land Area: 17905.00 sq.ft. ( aana, paisa, daam)
• Plinth area: 1536.00 sq. ft.
• Total floor: 2.5 floors
• House style: Stack Form Residence`,
    roomSpecifications: [
      'Ground Floor: Living Room, Kitchen, Dinning Hall, Walk in pantry, Storeroom, 1 bedroom with 1 common bathroom, Parking Area',
      'First Floor: 2 bedrooms with 1 common bathroom, 1 master bedroom with an attached bathroom and walk-in-closet, Pujaroom',
      'Top Floor: Terrace'
    ]
  },
  {
    id: 'bd6',
    title: 'City Stack',
    image: '/assets/ourdesigns/6.webp',
    description: 'A 4.5-storey residence designed for both rental and personal use with a modern urban look.',
    category: 'Elegant, Residence',
    area: '1711.60 (0-5-0-0)',
    plinthArea: '1050.94 sq. ft.',
    constructionTime: '15 to 18 months',
    stories: '4.5 stories',
    facingDirection: 'North',
    houseStyle: 'Modern Design',
    fullDescription: `This is a 4.5-storey City Stack residence built on 1711.60 sq.ft of land with a plinth area of 1050.94 sq.ft, designed for both rental and personal use, with a construction timeline of 15-18 months.

The lower floors are dedicated to rental purposes, featuring multiple bedrooms with attached and common bathrooms, kitchens, dining halls, living rooms, and parking. The upper floors are for personal use, including bedrooms with attached and common bathrooms, a kitchen, dining and living area, a multipurpose room, and an open terrace.

• Type: 3d design
• Construction: 10 to 12 months
• Land Area: 1711.60 sq.ft. ( 5 aana, 0 paisa, 0.02 daam)
• Plinth area: 1050.94 sq. ft.
• Total floor: 4.5 floors
• House style: Citystack Residence`,
    roomSpecifications: [
      'Ground Floor: 1 bedroom and 1 common bathroom, 1 bedroom with an attached bathroom, Parking Area, Living Room, Kitchen, Dinning Hall',
      'First Floor: 1 bedroom with an attached bathroom, 2 bedroooms with 1common bathroom, Living Room, Dinning Hall, Kitchen',
      'Second Floor: 1 bedroom and 1 common bathroom, 1 bedroom with an attached bathroom, Living Room, Dinning Hall, Kitchen',
      'Third Floor: Multipupose room and 1 common bathroom, 1 bedroom with an attached bathroom, Kitchen, Living Room, Open Terrace'
    ]
  },
  {
    id: 'bd7',
    title: 'Ivory Crest',
    image: '/assets/ourdesigns/7.webp',
    description: 'A 4.5-storey residence designed for both personal living and rental purposes.',
    category: 'Luxury, Residence',
    area: '1212 (0-3-2-1)',
    plinthArea: '783.00 sq. ft.',
    constructionTime: '15 to 18 months',
    stories: '4.5 stories',
    facingDirection: 'North',
    houseStyle: 'Modern Design',
    fullDescription: `This is a 4.5-storey Ivory Crest Residence built on a 1212 sq.ft land area ( 3 aana, 2 paisa, 0.66 daam) with a plinth area of 783.00 sq.ft, designed for both personal living and rental purposes. The project is estimated to be completed within 15 to 18 months.

The ground floor is dedicated to rental use, while the remaining floors are planned for residential living. The house features multiple bedrooms, including a master bedroom with an attached bathroom and walk-in closet, along with multiple kitchens, dining areas, living rooms, essential parking space, and multiple bathrooms, offering a well-balanced blend of comfort, functionality, and investment value.

• Type: 3d design
• Construction: 15 to 18 months
• Land Area: 1212 sq.ft. ( 3 aana, 2 paisa, 0.66 daam)
• Plinth area: 783.00 sq. ft.
• Total floor: 4.5 floors
• House style: Ivory Crest Residence`,
    roomSpecifications: [
      'Ground Floor: 1 bedroom with 1 common bathroom, Living Room, Kitchen, Dinning Hall, Parking Area',
      'First Floor: 4 bedrooms with 1 common bathroom',
      'Second Floor: 1 master bedroom with an attached bathroom and walk-in-closet, 2 bedrooms with 1 common bathroom',
      'Third Floor: Living Room, Kitchen, Dinning Hall, 1 common bathroom'
    ]
  },
  {
    id: 'bd8',
    title: 'Casa Verde',
    image: '/assets/ourdesigns/8.webp',
    description: 'A 2.5-storey residence designed for both rental and personal residential use.',
    category: 'Elegant, Residential',
    area: '1925 (0-5-2-2)',
    plinthArea: '1131.00 sq. ft.',
    constructionTime: '8 to 12 months',
    stories: '2.5 floors',
    facingDirection: 'South',
    houseStyle: 'Modern Design',
    fullDescription: `This is a 2.5-storey Casa Verde residence built on a 1925 sq.ft land area (5 aana,2 paisa,1.99 daam) with a plinth area of 1131 sq.ft, designed for both rental and personal residential use. The project is expected to be completed within 8 to 12 months.

The ground floor is dedicated to rental purposes, while the upper floors are reserved for personal use. The residence includes multiple bedrooms, including a master bedroom with an attached bathroom and walk-in closet, along with spacious living rooms, kitchens with pantry areas, dining rooms, an essential guest room with an attached bathroom, multiple store rooms, several bathrooms, a half-covered terrace, and a dedicated parking area.

• Type: 3d design
• Construction: 12 to 15 months
• Land Area: 1925.00 sq.ft. (5 aana,2 paisa,1.99 daam)
• Plinth area: 1131.00 sq. ft.
• Total floor: 2.5 floors
• House style: Casa Verde Residence`,
    roomSpecifications: [
      'Ground Floor: 2 bedrooms with 2 common bathrooms, Living room, Kitchen, Dinning Hall, Storeroom',
      'First Floor: Living Room, Dinning Hall, Kitchen, Storeroom, 1 Guestroom with an attached bathroom, 1 common bathroom',
      'Second Floor: 2 master bedrooms each with a private attached bathroom and walk-in-closet, Storeroom, Living room, Terrace'
    ]
  }
];

export const COMPANY_NAME = "Visioncraft Civil Solutions";
export const TAGLINE = "Engineering Safe, Sustainable Infrastructure";
export const SUB_TAGLINE = "RCC | Structural Design | Geotechnical | PM | Interior | Valuation | Environmental";

export const SERVICES: Service[] = [
  {
    id: 'struct',
    title: 'Structural Engineering',
    description: 'Advanced analysis and design of RCC and steel structures compliant with IS and NBC codes.',
    icon: Building2,
    image: '/assets/Structural Engineering.webp',
    details: ['High-rise Building Design', 'Industrial Steel Structures', 'Seismic Retrofitting', 'Finite Element Analysis']
  },
  {
    id: 'geo',
    title: 'Geotechnical Engineering',
    description: 'Comprehensive soil investigation and foundation system design for complex terrains.',
    icon: Layers,
    image: '/assets/Geotechnical Engineering.webp',
    details: ['Soil Testing & Reports', 'Pile Foundation Design', 'Slope Stability Analysis', 'Retaining Wall Design']
  },
  {
    id: 'pm',
    title: 'Project Management',
    description: 'End-to-end construction supervision, quality control, and cost estimation.',
    icon: HardHat,
    image: '/assets/project_management.webp',
    details: ['Site Supervision', 'Bill of Quantities (BoQ)', 'Quality Assurance/Control', 'Contract Management']
  },
  {
    id: 'survey',
    title: 'Surveying & Planning',
    description: 'Precision land measurement and municipal layout planning.',
    icon: Ruler,
    image: '/assets/surveying.webp',
    details: ['Topographical Survey', 'Municipal Drawings', 'Land Development Planning', 'GIS Mapping']
  },
  {
    id: 'interior',
    title: 'Interior Design',
    description: 'Aesthetic and functional interior space planning for residential and commercial projects.',
    icon: Palette,
    image: 'https://images.unsplash.com/photo-1618221195710-dd6b41faaea6?q=80&w=1000&auto=format&fit=crop',
    details: ['3D Interior Visualization', 'Space Optimization', 'Material Selection', 'Lighting Design']
  },
  {
    id: 'valuation',
    title: 'Estimation, Costing & Valuation',
    description: 'Detailed financial assessment, quantity surveying, and property valuation services.',
    icon: Calculator,
    image: 'https://images.unsplash.com/photo-1554224155-6726b3ff858f?q=80&w=1000&auto=format&fit=crop',
    details: ['Detailed Estimating', 'Bill of Quantities (BoQ)', 'Bank Valuation', 'Cost Analysis']
  },
  {
    id: 'env',
    title: 'Environmental Study',
    description: 'Specialized environmental impact assessments and feasibility studies (BES, IEE, EIA).',
    icon: Leaf,
    image: 'https://images.unsplash.com/photo-1464822759023-fed622ff2c3b?q=80&w=1000&auto=format&fit=crop',
    details: ['Brief Environmental Study (BES)', 'Initial Environmental Examination (IEE)', 'Environmental Impact Assessment (EIA)', 'Sustainability Consulting']
  }
];


export const TEAM: TeamMember[] = [
  {
    id: 't1',
    name: 'Er. Deepak Raj Joshi',
    designation: 'Civil Engineer',
    qualification: 'BE ACEM, (TU)',
    necReg: 'NEC-92802-Civil',
    image: '/Teams/deepak.webp'
  },
  {
    id: 't2',
    name: 'Er. Ishan Pokharel',
    designation: 'Civil Engineer',
    qualification: 'BE Pulchowk Campus, (TU)',
    necReg: 'NEC-92922-Civil',
    image: '/Teams/ishan.webp'
  },
  {
    id: 't3',
    name: 'Er. Dilip Rayamajhi',
    designation: 'Civil Engineer',
    qualification: 'BE Pulchowk Campus, (TU)',
    necReg: 'NEC-92827-Civil',
    image: '/Teams/saroj.webp'
  }
];

export const PUBLICATIONS: Publication[] = [
  {
    id: 'pub1',
    title: 'Seismic Performance of Infill Masonry Walls in RC Frames',
    journal: 'Journal of Structural Engineering',
    year: '2023',
    link: '#'
  },
  {
    id: 'pub2',
    title: 'Cost Optimization of Pile Foundations in Sandy Soil',
    journal: 'International Conference on Geotechnics',
    year: '2022',
    link: '#'
  }
];