

export type SupportType = 'pin' | 'roller' | 'fixed' | 'spring_y';
export type LoadType = 'point' | 'moment' | 'udl' | 'uvl';

// --- BEAM TYPES (Existing) ---
export interface Support {
    id: string;
    type: SupportType;
    x: number; // Global coordinate
    settlement?: number; // m
    rotation?: number; // rad
    stiffness?: number; // kN/m (for springs)
}

export interface Hinge {
    id: string;
    x: number; // Global coordinate
}

export interface Load {
    id: string;
    type: LoadType;
    value: number; // Magnitude (kN or kNm or kN/m)
    x?: number; // For point/moment
    start?: number; // For UDL/UVL
    end?: number; // For UDL/UVL
    valueStart?: number; // For UVL
    valueEnd?: number; // For UVL
    angle_deg?: number; // For inclined loads
}

export interface Span {
    id: string;
    length: number;
}

export interface Section {
    id?: string;
    x: number; // Start x
    end?: number; // End x
    E: number; // kPa
    I: number; // m^4
    depth?: number; // m (for stress calculation)
}

export interface BeamConfig {
    length: number; 
    E: number; 
    I: number; 
    depth?: number; 
    supports: Support[]; 
    loads: Load[]; 
    hinges: Hinge[]; 
    sections?: Section[];
    
    // Engine legacy structure compatibility
    spans?: any[]; 
    globalLoads?: any[];
    targetElementSize?: number;
}

// --- RESULT TYPES ---
export interface Point {
    x: number;
    value: number;
}

export interface Diagrams {
    x: number[];
    shear: number[];
    moment: number[];
    deflection: number[];
    bendingStress: number[]; // kPa
    rotation?: number[];
}

export interface ReactionComponent {
    Fy: number;
    Mz: number;
}

export interface AnalysisResult {
    diagrams: Diagrams;
    reactions: Record<number, ReactionComponent>; // x -> {Fy, Mz}
    summary: {
        maxShear: Point;
        maxMoment: Point;
        maxDeflection: Point;
        maxStress: Point;
    };
}

export interface ILDResult {
    x: number[];
    value: number[];
}

export type ILDTargetType = 'reaction' | 'shear' | 'moment' | 'deflection';
