
export type SupportType = 'pin' | 'roller' | 'fixed' | 'spring_y';
export type LoadType = 'point' | 'moment' | 'udl' | 'uvl';

export interface Support {
    id: string;
    type: SupportType;
    x: number;
    settlement?: number;
    rotation?: number;
    stiffness?: number;
}

export interface Hinge {
    id: string;
    x: number;
}

export interface Load {
    id: string;
    type: LoadType;
    value: number;
    x?: number;
    start?: number;
    end?: number;
    valueStart?: number;
    valueEnd?: number;
    angle_deg?: number;
}

export interface Span {
    id: string;
    length: number;
}

export interface Section {
    id?: string;
    x: number;
    end?: number;
    E: number;
    I: number;
    depth?: number;
}

export interface BeamConfig {
    length: number;
    E: number;
    I: number;
    depth?: number;
    supports: Support[];
    loads: Load[];
    hinges: Hinge[];
    sections?: Section[];
    spans?: any[];
    globalLoads?: any[];
    targetElementSize?: number;
}

export interface Point {
    x: number;
    value: number;
}

export interface Diagrams {
    x: number[];
    shear: number[];
    moment: number[];
    deflection: number[];
    bendingStress: number[];
    rotation?: number[];
}

export interface ReactionComponent {
    Fy: number;
    Mz: number;
}

export interface AnalysisResult {
    diagrams: Diagrams;
    reactions: Record<number, ReactionComponent>;
    summary: {
        maxShear: Point;
        maxMoment: Point;
        maxDeflection: Point;
        maxStress: Point;
    };
}

export interface ILDResult {
    x: number[];
    value: number[];
}

export type ILDTargetType = 'reaction' | 'shear' | 'moment' | 'deflection';
